/*
 * Decompiled with CFR 0.152.
 */
package ai.pqcrypto.sdk;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.interfaces.MLDSAPrivateKey;
import org.bouncycastle.jcajce.spec.MLDSAParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public class MLDSATlsPkcs12Client {
    private final byte[] clientCertBytes;
    private final byte[] caCertBytes;
    private final AsymmetricKeyParameter clientPrivateKey;
    private final MLDSAParameters mldsaParams;
    private final int connectTimeout;
    private final int readTimeout;

    private MLDSATlsPkcs12Client(Builder builder) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
        try (FileInputStream fis = new FileInputStream(builder.keyStorePath);){
            keyStore.load(fis, builder.keyStorePassword.toCharArray());
        }
        String alias = keyStore.aliases().nextElement();
        java.security.cert.Certificate[] certChain = keyStore.getCertificateChain(alias);
        if (certChain == null || certChain.length == 0) {
            throw new IllegalArgumentException("No certificate chain found in keystore");
        }
        this.clientCertBytes = certChain[0].getEncoded();
        if (certChain.length > 1) {
            this.caCertBytes = certChain[1].getEncoded();
        } else {
            KeyStore trustStore = KeyStore.getInstance("PKCS12", "BC");
            try (FileInputStream fis = new FileInputStream(builder.trustStorePath);){
                trustStore.load(fis, builder.trustStorePassword.toCharArray());
            }
            String caAlias = trustStore.aliases().nextElement();
            this.caCertBytes = trustStore.getCertificate(caAlias).getEncoded();
        }
        Key key = keyStore.getKey(alias, builder.keyStorePassword.toCharArray());
        if (!(key instanceof MLDSAPrivateKey)) {
            throw new IllegalArgumentException("Expected ML-DSA private key, got: " + key.getClass().getName());
        }
        MLDSAPrivateKey mldsaKey = (MLDSAPrivateKey)key;
        MLDSAParameterSpec spec = mldsaKey.getParameterSpec();
        this.mldsaParams = MLDSATlsPkcs12Client.specToParams(spec);
        byte[] seed = mldsaKey.getSeed();
        this.clientPrivateKey = new MLDSAPrivateKeyParameters(this.mldsaParams, seed, null);
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public Response get(String host, int port, String path) throws Exception {
        return this.request("GET", host, port, path, null, null);
    }

    public Response get(String host, int port, String path, Map<String, String> headers) throws Exception {
        return this.request("GET", host, port, path, headers, null);
    }

    public Response post(String host, int port, String path, String body) throws Exception {
        return this.request("POST", host, port, path, null, body);
    }

    public Response post(String host, int port, String path, Map<String, String> headers, String body) throws Exception {
        return this.request("POST", host, port, path, headers, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response request(String method, String host, int port, String path, Map<String, String> headers, String body) throws Exception {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port), this.connectTimeout);
        socket.setSoTimeout(this.readTimeout);
        BcTlsCrypto crypto = new BcTlsCrypto(new SecureRandom());
        TlsClientProtocol protocol = new TlsClientProtocol(socket.getInputStream(), socket.getOutputStream());
        try {
            protocol.connect(this.createTlsClient(crypto, host));
            StringBuilder request = new StringBuilder();
            request.append(method).append(" ").append(path).append(" HTTP/1.1\r\n");
            request.append("Host: ").append(host).append("\r\n");
            request.append("Connection: close\r\n");
            if (headers != null) {
                for (Map.Entry<String, String> h : headers.entrySet()) {
                    request.append(h.getKey()).append(": ").append(h.getValue()).append("\r\n");
                }
            }
            if (body != null) {
                byte[] bodyBytes = body.getBytes(StandardCharsets.UTF_8);
                if (headers == null || !headers.containsKey("Content-Type")) {
                    request.append("Content-Type: application/json\r\n");
                }
                request.append("Content-Length: ").append(bodyBytes.length).append("\r\n");
                request.append("\r\n");
                request.append(body);
            } else {
                request.append("\r\n");
            }
            OutputStream output = protocol.getOutputStream();
            output.write(request.toString().getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = protocol.getInputStream();
            Response response = this.parseResponse(input);
            return response;
        }
        finally {
            try {
                protocol.close();
            }
            catch (Exception exception) {}
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    private DefaultTlsClient createTlsClient(final BcTlsCrypto crypto, String host) {
        return new DefaultTlsClient(crypto){

            @Override
            public TlsAuthentication getAuthentication() {
                return new TlsAuthentication(){

                    @Override
                    public void notifyServerCertificate(TlsServerCertificate serverCertificate) {
                    }

                    @Override
                    public TlsCredentials getClientCredentials(CertificateRequest request) throws IOException {
                        CertificateEntry[] entries = new CertificateEntry[]{new CertificateEntry(new BcTlsCertificate(crypto, MLDSATlsPkcs12Client.this.clientCertBytes), null), new CertificateEntry(new BcTlsCertificate(crypto, MLDSATlsPkcs12Client.this.caCertBytes), null)};
                        Certificate cert = new Certificate(new byte[0], entries);
                        SignatureAndHashAlgorithm sigAlg = MLDSATlsPkcs12Client.this.getSignatureAlgorithm();
                        return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(context), crypto, MLDSATlsPkcs12Client.this.clientPrivateKey, cert, sigAlg);
                    }
                };
            }

            @Override
            protected int[] getSupportedCipherSuites() {
                return new int[]{4866, 4865, 4867};
            }

            @Override
            protected ProtocolVersion[] getSupportedVersions() {
                return new ProtocolVersion[]{ProtocolVersion.TLSv13};
            }
        };
    }

    private SignatureAndHashAlgorithm getSignatureAlgorithm() {
        if (this.mldsaParams == MLDSAParameters.ml_dsa_44) {
            return SignatureAndHashAlgorithm.mldsa44;
        }
        if (this.mldsaParams == MLDSAParameters.ml_dsa_87) {
            return SignatureAndHashAlgorithm.mldsa87;
        }
        return SignatureAndHashAlgorithm.mldsa65;
    }

    private static MLDSAParameters specToParams(MLDSAParameterSpec spec) {
        String name = spec.getName();
        if (name.equals("ML-DSA-44")) {
            return MLDSAParameters.ml_dsa_44;
        }
        if (name.equals("ML-DSA-87")) {
            return MLDSAParameters.ml_dsa_87;
        }
        return MLDSAParameters.ml_dsa_65;
    }

    private Response parseResponse(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        String statusLine = reader.readLine();
        if (statusLine == null) {
            throw new IOException("Empty response");
        }
        String[] statusParts = statusLine.split(" ", 3);
        int statusCode = Integer.parseInt(statusParts[1]);
        String statusMessage = statusParts.length > 2 ? statusParts[2] : "";
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        int contentLength = -1;
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            int idx = line.indexOf(58);
            if (idx <= 0) continue;
            String key = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            headers.put(key, value);
            if (!key.equalsIgnoreCase("Content-Length")) continue;
            contentLength = Integer.parseInt(value);
        }
        StringBuilder body = new StringBuilder();
        if (contentLength > 0) {
            char[] buffer = new char[contentLength];
            int read = reader.read(buffer, 0, contentLength);
            if (read > 0) {
                body.append(buffer, 0, read);
            }
        } else {
            while ((line = reader.readLine()) != null) {
                body.append(line).append("\n");
            }
        }
        return new Response(statusCode, statusMessage, headers, body.toString().trim());
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
        }
    }

    public static class Builder {
        private String keyStorePath;
        private String keyStorePassword;
        private String trustStorePath;
        private String trustStorePassword;
        private int connectTimeout = 10000;
        private int readTimeout = 30000;

        public Builder keyStore(String path, String password) {
            this.keyStorePath = path;
            this.keyStorePassword = password;
            return this;
        }

        public Builder trustStore(String path, String password) {
            this.trustStorePath = path;
            this.trustStorePassword = password;
            return this;
        }

        public Builder connectTimeout(int ms) {
            this.connectTimeout = ms;
            return this;
        }

        public Builder readTimeout(int ms) {
            this.readTimeout = ms;
            return this;
        }

        public MLDSATlsPkcs12Client build() throws Exception {
            Objects.requireNonNull(this.keyStorePath, "keyStore path is required");
            Objects.requireNonNull(this.keyStorePassword, "keyStore password is required");
            Objects.requireNonNull(this.trustStorePath, "trustStore path is required");
            Objects.requireNonNull(this.trustStorePassword, "trustStore password is required");
            return new MLDSATlsPkcs12Client(this);
        }
    }

    public static class Response {
        private final int statusCode;
        private final String statusMessage;
        private final Map<String, String> headers;
        private final String body;

        Response(int statusCode, String statusMessage, Map<String, String> headers, String body) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = headers;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public boolean isSuccess() {
            return this.statusCode >= 200 && this.statusCode < 300;
        }

        public String toString() {
            return "Response{status=" + this.statusCode + " " + this.statusMessage + ", bodyLength=" + (this.body != null ? this.body.length() : 0) + "}";
        }
    }
}

