/*
 * Decompiled with CFR 0.152.
 */
package ai.pqcrypto.sdk;

import ai.pqcrypto.sdk.MLDSATlsClient;
import ai.pqcrypto.sdk.MLDSATlsPkcs12Client;
import java.util.HashMap;
import java.util.Map;

public class Main {
    private static final String VERSION = "1.0.0";

    public static void main(String[] args) {
        try {
            String host;
            if (args.length == 0 || Main.hasFlag(args, "--help", "-h")) {
                Main.printHelp();
                return;
            }
            if (Main.hasFlag(args, "--version", "-v")) {
                System.out.println("java_pqc version 1.0.0");
                return;
            }
            Map<String, String> params = Main.parseArgs(args);
            String mode = params.get("mode");
            if (mode == null) {
                System.err.println("Error: --mode is required (pem or pkcs12)");
                System.exit(1);
            }
            if ((host = params.get("host")) == null) {
                System.err.println("Error: --host is required");
                System.exit(1);
            }
            int port = Integer.parseInt(params.getOrDefault("port", "443"));
            String path = params.getOrDefault("path", "/");
            String method = params.getOrDefault("method", "GET").toUpperCase();
            String body = params.get("body");
            int mldsa = Integer.parseInt(params.getOrDefault("mldsa", "65"));
            System.out.println("=== PQCrypto ML-DSA TLS Client v1.0.0 ===");
            System.out.println();
            if ("pem".equalsIgnoreCase(mode)) {
                Main.executePemMode(params, host, port, path, method, body, mldsa);
            } else if ("pkcs12".equalsIgnoreCase(mode)) {
                Main.executePkcs12Mode(params, host, port, path, method, body);
            } else {
                System.err.println("Error: Invalid mode '" + mode + "'. Use 'pem' or 'pkcs12'");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void executePemMode(Map<String, String> params, String host, int port, String path, String method, String body, int mldsa) throws Exception {
        String cert = params.get("cert");
        String key = params.get("key");
        String ca = params.get("ca");
        if (cert == null || key == null || ca == null) {
            System.err.println("Error: PEM mode requires --cert, --key, and --ca");
            System.exit(1);
        }
        System.out.println("Mode: PEM");
        System.out.println("Certificate: " + cert);
        System.out.println("Private Key: " + key);
        System.out.println("CA Certificate: " + ca);
        System.out.println("ML-DSA: ML-DSA-" + mldsa);
        System.out.println("Target: " + host + ":" + port + path);
        System.out.println("Method: " + method);
        System.out.println();
        MLDSATlsClient.Builder builder = new MLDSATlsClient.Builder().clientCert(cert).clientKey(key).caCert(ca);
        switch (mldsa) {
            case 44: {
                builder.useMlDsa44();
                break;
            }
            case 87: {
                builder.useMlDsa87();
                break;
            }
            default: {
                builder.useMlDsa65();
            }
        }
        MLDSATlsClient client = builder.build();
        System.out.println("Connecting...");
        System.out.println();
        MLDSATlsClient.Response response = "POST".equals(method) && body != null ? client.post(host, port, path, body) : ("POST".equals(method) ? client.post(host, port, path, "") : client.get(host, port, path));
        Main.printResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), response.getBody(), response.isSuccess());
    }

    private static void executePkcs12Mode(Map<String, String> params, String host, int port, String path, String method, String body) throws Exception {
        String keystore = params.get("keystore");
        String keystorePassword = params.get("keystore-password");
        String truststore = params.get("truststore");
        String truststorePassword = params.get("truststore-password");
        if (keystore == null || keystorePassword == null) {
            System.err.println("Error: PKCS12 mode requires --keystore and --keystore-password");
            System.exit(1);
        }
        if (truststore == null || truststorePassword == null) {
            System.err.println("Error: PKCS12 mode requires --truststore and --truststore-password");
            System.exit(1);
        }
        System.out.println("Mode: PKCS12");
        System.out.println("KeyStore: " + keystore);
        System.out.println("TrustStore: " + truststore);
        System.out.println("Target: " + host + ":" + port + path);
        System.out.println("Method: " + method);
        System.out.println();
        MLDSATlsPkcs12Client client = new MLDSATlsPkcs12Client.Builder().keyStore(keystore, keystorePassword).trustStore(truststore, truststorePassword).build();
        System.out.println("Connecting...");
        System.out.println();
        MLDSATlsPkcs12Client.Response response = "POST".equals(method) && body != null ? client.post(host, port, path, body) : ("POST".equals(method) ? client.post(host, port, path, "") : client.get(host, port, path));
        Main.printResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), response.getBody(), response.isSuccess());
    }

    private static void printResponse(int statusCode, String statusMessage, Map<String, String> headers, String body, boolean success) {
        System.out.println("=== Response ===");
        System.out.println("Status: " + statusCode + " " + statusMessage);
        System.out.println();
        System.out.println("Headers:");
        for (Map.Entry<String, String> h : headers.entrySet()) {
            System.out.println("  " + h.getKey() + ": " + h.getValue());
        }
        System.out.println();
        System.out.println("Body:");
        System.out.println(body);
        System.out.println();
        System.out.println("Success: " + success);
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key;
            String arg = args[i];
            if (arg.startsWith("--")) {
                key = arg.substring(2);
                if (i + 1 < args.length && !args[i + 1].startsWith("--")) {
                    params.put(key, args[i + 1]);
                    ++i;
                    continue;
                }
                params.put(key, "true");
                continue;
            }
            if (!arg.startsWith("-") || arg.length() != 2) continue;
            key = arg.substring(1);
            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                params.put(key, args[i + 1]);
                ++i;
                continue;
            }
            params.put(key, "true");
        }
        return params;
    }

    private static boolean hasFlag(String[] args, String longFlag, String shortFlag) {
        for (String arg : args) {
            if (!arg.equals(longFlag) && !arg.equals(shortFlag)) continue;
            return true;
        }
        return false;
    }

    private static void printHelp() {
        System.out.println("PQCrypto ML-DSA TLS Client v1.0.0");
        System.out.println();
        System.out.println("Post-Quantum Cryptography TLS Client using ML-DSA (FIPS 204)");
        System.out.println();
        System.out.println("USAGE:");
        System.out.println("  java -jar pqc_java_client-1.0.0.jar --mode <pem|pkcs12> [OPTIONS]");
        System.out.println();
        System.out.println("MODES:");
        System.out.println("  pem      Use PEM certificate files (.crt, .key)");
        System.out.println("  pkcs12   Use PKCS12 keystore (.p12) and JKS truststore (.jks)");
        System.out.println();
        System.out.println("COMMON OPTIONS:");
        System.out.println("  --host <hostname>       Target hostname (required)");
        System.out.println("  --port <port>           Target port (default: 443)");
        System.out.println("  --path <path>           Request path (default: /)");
        System.out.println("  --method <GET|POST>     HTTP method (default: GET)");
        System.out.println("  --body <data>           Request body for POST");
        System.out.println("  --help, -h              Show this help");
        System.out.println("  --version, -v           Show version");
        System.out.println();
        System.out.println("PEM MODE OPTIONS:");
        System.out.println("  --cert <path>           Client certificate file (.crt)");
        System.out.println("  --key <path>            Client private key file (.key)");
        System.out.println("  --ca <path>             CA certificate file (.crt)");
        System.out.println("  --mldsa <44|65|87>      ML-DSA parameter (default: 65)");
        System.out.println();
        System.out.println("PKCS12 MODE OPTIONS:");
        System.out.println("  --keystore <path>              PKCS12 keystore file (.p12)");
        System.out.println("  --keystore-password <pass>     Keystore password");
        System.out.println("  --truststore <path>            JKS truststore file (.jks)");
        System.out.println("  --truststore-password <pass>   Truststore password");
        System.out.println();
        System.out.println("EXAMPLES:");
        System.out.println();
        System.out.println("  # PEM mode");
        System.out.println("  java -jar pqc_java_client-1.0.0.jar --mode pem \\");
        System.out.println("    --cert pki/client.crt --key pki/client.key --ca pki/ca.crt \\");
        System.out.println("    --host example.com --port 443 --path /v1/health");
        System.out.println();
        System.out.println("  # PKCS12 mode");
        System.out.println("  java -jar pqc_java_client-1.0.0.jar --mode pkcs12 \\");
        System.out.println("    --keystore pki/client.p12 --keystore-password secret \\");
        System.out.println("    --truststore pki/truststore.jks --truststore-password secret \\");
        System.out.println("    --host example.com --port 443 --path /v1/health");
        System.out.println();
    }
}

