/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsSession;

class ProvSSLSessionResumed
extends ProvSSLSessionHandshake {
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;
    protected final long lastAccessedTime;

    ProvSSLSessionResumed(ProvSSLSessionContext provSSLSessionContext, String string, int n, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession provSSLSession) {
        super(provSSLSessionContext, provSSLSession.getValueMap(), string, n, provSSLSession.getCreationTime(), securityParameters, jsseSecurityParameters);
        this.tlsSession = provSSLSession.getTlsSession();
        this.sessionParameters = this.tlsSession.exportSessionParameters();
        this.jsseSessionParameters = provSSLSession.getJsseSessionParameters();
        this.lastAccessedTime = provSSLSession.access();
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.tlsSession.getSessionID();
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.sessionParameters.getLocalCertificate();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.sessionParameters.getPeerCertificate();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    protected void invalidateTLS() {
        this.tlsSession.invalidate();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.tlsSession.isResumable();
    }
}

