/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeType;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.TlsClientProtocol;

class ProvTlsClientProtocol
extends TlsClientProtocol {
    private static final Logger LOG = Logger.getLogger(ProvTlsClientProtocol.class.getName());
    private static final boolean provAcceptRenegotiation = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.acceptRenegotiation", false);
    private final Closeable closeable;

    ProvTlsClientProtocol(InputStream inputStream, OutputStream outputStream, Closeable closeable) {
        super(inputStream, outputStream);
        this.closeable = closeable;
    }

    @Override
    protected void closeConnection() throws IOException {
        this.closeable.close();
    }

    @Override
    protected int getRenegotiationPolicy() {
        return provAcceptRenegotiation ? 2 : 0;
    }

    @Override
    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (LOG.isLoggable(Level.FINEST)) {
            int n = handshakeMessageInput.available();
            LOG.finest(this.getClientID() + " inbound handshake message: " + HandshakeType.getText(s) + "[" + n + "]");
        }
        super.handleHandshakeMessage(s, handshakeMessageInput);
    }

    @Override
    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        ServerHello serverHello = super.receiveServerHelloMessage(byteArrayInputStream);
        if (LOG.isLoggable(Level.FINEST)) {
            String string = this.getClientID() + " ServerHello extensions";
            LOG.finest(JsseUtils.getExtensionsReport(string, serverHello.getExtensions()));
        }
        return serverHello;
    }

    @Override
    protected void sendClientHelloMessage() throws IOException {
        if (LOG.isLoggable(Level.FINEST)) {
            String string = this.getClientID() + " ClientHello extensions";
            LOG.finest(JsseUtils.getExtensionsReport(string, this.clientHello.getExtensions()));
        }
        super.sendClientHelloMessage();
    }

    private String getClientID() {
        return ((ProvTlsClient)this.tlsClient).getID();
    }
}

