/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

public final class TlsSuiteHMac
implements TlsSuiteMac {
    private static final long SEQUENCE_NUMBER_PLACEHOLDER = -1L;
    private final TlsCryptoParameters cryptoParams;
    private final TlsHMAC mac;
    private final int digestBlockSize;
    private final int digestOverhead;
    private final int macSize;

    private static int getMacSize(TlsCryptoParameters tlsCryptoParameters, TlsMAC tlsMAC) {
        int n = tlsMAC.getMacLength();
        if (tlsCryptoParameters.getSecurityParametersHandshake().isTruncatedHMac()) {
            n = Math.min(n, 10);
        }
        return n;
    }

    public TlsSuiteHMac(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC) {
        this.cryptoParams = tlsCryptoParameters;
        this.mac = tlsHMAC;
        this.macSize = TlsSuiteHMac.getMacSize(tlsCryptoParameters, tlsHMAC);
        this.digestBlockSize = tlsHMAC.getInternalBlockSize();
        this.digestOverhead = TlsImplUtils.isSSL(tlsCryptoParameters) && tlsHMAC.getMacLength() == 20 ? 4 : this.digestBlockSize / 8;
    }

    @Override
    public int getSize() {
        return this.macSize;
    }

    @Override
    public byte[] calculateMac(long l, short s, byte[] byArray, byte[] byArray2, int n, int n2) {
        ProtocolVersion protocolVersion = this.cryptoParams.getServerVersion();
        if (!Arrays.isNullOrEmpty(byArray)) {
            int n3 = byArray.length;
            byte[] byArray3 = new byte[23 + n3];
            TlsUtils.writeUint64(-1L, byArray3, 0);
            TlsUtils.writeUint8((short)25, byArray3, 8);
            TlsUtils.writeUint8(n3, byArray3, 9);
            TlsUtils.writeUint8((short)25, byArray3, 10);
            TlsUtils.writeVersion(protocolVersion, byArray3, 11);
            TlsUtils.writeUint64(l, byArray3, 13);
            System.arraycopy(byArray, 0, byArray3, 21, n3);
            TlsUtils.writeUint16(n2, byArray3, 21 + n3);
            this.mac.update(byArray3, 0, byArray3.length);
        } else {
            byte[] byArray4 = new byte[13];
            TlsUtils.writeUint64(l, byArray4, 0);
            TlsUtils.writeUint8(s, byArray4, 8);
            TlsUtils.writeVersion(protocolVersion, byArray4, 9);
            TlsUtils.writeUint16(n2, byArray4, 11);
            this.mac.update(byArray4, 0, byArray4.length);
        }
        this.mac.update(byArray2, n, n2);
        return this.truncate(this.mac.calculateMAC());
    }

    @Override
    public byte[] calculateMacConstantTime(long l, short s, byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte[] byArray3) {
        byte[] byArray4 = this.calculateMac(l, s, byArray, byArray2, n, n2);
        int n4 = this.getHeaderLength(byArray);
        int n5 = this.getDigestBlockCount(n4 + n3) - this.getDigestBlockCount(n4 + n2);
        while (--n5 >= 0) {
            this.mac.update(byArray3, 0, this.digestBlockSize);
        }
        this.mac.update(byArray3, 0, 1);
        this.mac.reset();
        return byArray4;
    }

    private int getDigestBlockCount(int n) {
        return (n + this.digestOverhead) / this.digestBlockSize;
    }

    private int getHeaderLength(byte[] byArray) {
        if (TlsImplUtils.isSSL(this.cryptoParams)) {
            return 11;
        }
        if (!Arrays.isNullOrEmpty(byArray)) {
            return 23 + byArray.length;
        }
        return 13;
    }

    private byte[] truncate(byte[] byArray) {
        if (byArray.length <= this.macSize) {
            return byArray;
        }
        return Arrays.copyOf(byArray, this.macSize);
    }
}

