/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsECDSA13Signer
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final int signatureScheme;

    public JcaTlsECDSA13Signer(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, int n) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        if (!SignatureScheme.isECDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.signatureScheme = n;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        try {
            try {
                return JcaTlsECDSA13Signer.implGenerateRawSignature(this.crypto.getHelper(), this.privateKey, secureRandom, byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                JcaJceHelper jcaJceHelper = this.crypto.getAltHelper();
                if (jcaJceHelper == null) {
                    throw invalidKeyException;
                }
                return JcaTlsECDSA13Signer.implGenerateRawSignature(jcaJceHelper, this.privateKey, secureRandom, byArray);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        return null;
    }

    private static byte[] implGenerateRawSignature(JcaJceHelper jcaJceHelper, PrivateKey privateKey, SecureRandom secureRandom, byte[] byArray) throws GeneralSecurityException {
        Signature signature = jcaJceHelper.createSignature("NoneWithECDSA");
        signature.initSign(privateKey, secureRandom);
        signature.update(byArray, 0, byArray.length);
        return signature.sign();
    }
}

